<?php

defined('ABSPATH') || exit();

class Payrex_Controller_Payment_Callback
{
    /**
     * Method to register routes to WooCommerce
     */
    public function register_routes()
    {
        register_rest_route('wc-payrex/v1', 'payment-callback', [
            'methods'             => WP_REST_Server::READABLE,
            'callback'            => [$this, 'process_callback'],
            'permission_callback' => '__return_true',
            'args'                => [
                'order_id'          => [
                    'required' => true
                ],
                'order_key'          => [
                    'required' => true
                ],
                'source' => [
                    'required' => true
                ]
            ],
        ]);
    }

    // phpcs:disable WordPress.Security.NonceVerification.Recommended
    public function process_callback()
    {
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Read-only admin notice flag
        $orderId = isset($_GET['order_id']) ? sanitize_text_field(wp_unslash($_GET['order_id'])) : null;
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Read-only admin notice flag
        $orderKey = isset($_GET['order_key']) ? sanitize_text_field(wp_unslash($_GET['order_key'])) : null;
        // phpcs:ignore WordPress.Security.NonceVerification.Recommended -- Read-only admin notice flag
        $source = isset($_GET['source']) ? sanitize_text_field(wp_unslash($_GET['source'])) : null;

        $order = wc_get_order($orderId);

        $url = '';

        if ($source == 'order-pay') {
            $url = $order->get_checkout_payment_url();
        } elseif ($source == 'checkout') {
            $url = wc_get_checkout_url();
        }

        if ($order && $order->get_order_key() === $orderKey) {
            $gateway = WC()->payment_gateways()->get_available_payment_gateways()['payrex'];

            if (!$gateway) {
                return new WP_Error('action_forbidden', 'Gateway is disabled');
            }

            $secretKey = $gateway->getSecretKey();
            $paymentIntentId = $order->get_meta('_payrex_intent_id');
            $client = new \Payrex\PayrexClient($secretKey);
            $paymentIntent = null;

            if ($paymentIntentId || !empty($paymentIntentId)) {
                try {
                    $paymentIntent = $client->paymentIntents->retrieve($paymentIntentId);
                } catch (\Payrex\Exceptions\ResourceNotFoundException $e) {
                    $paymentIntent = null;
                } catch (\Payrex\Exceptions\BaseException $e) {
                    $paymentIntent = null;
                }

                if (!$paymentIntent) {
                    wc_add_notice('Invalid payment request.', 'error', ['contexts' => 'wc/checkout/payments']);
                } else {
                    if ($paymentIntent->status == 'succeeded') {
                        $url = $order->get_checkout_order_received_url();
                    } else {
                        $error_message = $paymentIntent->last_payment_error['detail'];

                        wc_add_notice($error_message, 'error', ['contexts' => 'wc/checkout/payments']);
                    }
                }
            } else {
                wc_add_notice('Invalid payment request.', 'error', ['contexts' => 'wc/checkout/payments']);
            }
        } else {
            wp_die('You shall not pass!!', 'Forbidden', ['response' => 403]);
        }

        wp_safe_redirect($url);
        exit;
    }
    // phpcs:enable WordPress.Security.NonceVerification.Recommended
}
