<?php

/**
 * Plugin Name: Payments via PayRex for WooCommerce
 * Description: Secure and unified payments powered by PayRex
 * Version: 1.0.1
 * Author: PayRex
 * Author URI: https://payrex.com
 * Developer: PayRex
 * Developer URI: https://payrex.com
 * Requires Plugins: woocommerce
 * Requires at least: 6.6
 * Tested up to: 6.9
 * Requires PHP: 7.0
 * WC requires at least: 10.0
 * WC tested up to: 10.3
 * License:     GPLv2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 * Text Domain: payments-via-payrex-for-woocommerce
 */

// This is the entry point of the plugin.

defined( 'ABSPATH' ) || exit;

define('PAYREX_GATEWAY_FILE', __FILE__);
define('PAYREX_GATEWAY_DIR_PATH', plugin_dir_path(__FILE__));

// require auto-loader
require_once __DIR__ . '/vendor/autoload.php';
require_once plugin_dir_path(__FILE__) . 'includes/class-payrex-extension-loader.php';

function initialize_payrex_gateway()
{
    $plugin = new Payrex_Extension_Loader();
    
    $plugin->loadFiles();
    $plugin->init();
}

add_action('plugins_loaded', 'initialize_payrex_gateway', 10);
