import amex from '../Images/amex-square-icon.svg'
import bdo from '../Images/bdo-square-icon.svg'
import diners from '../Images/diners-square-icon.svg'
import discover from '../Images/discover-square-icon.svg'
import gcash from '../Images/gcash-square-icon.svg'
import jcb from '../Images/jcb-square-icon.svg'
import mastercard from '../Images/mastercard-square-icon.svg'
import maya from '../Images/maya-square-icon.svg'
import qrph from '../Images/qrph-square-icon.svg'
import visa from '../Images/visa-square-icon.svg'

const PAYMENT_METHOD_ICONS_MAP = {
  amex: amex,
  bdo: bdo,
  diners: diners,
  discover: discover,
  gcash: gcash,
  jcb: jcb,
  mastercard: mastercard,
  maya: maya,
  qrph: qrph,
  visa: visa
}

const PaymentMethodIcon = ({
  className = 'h-6 w-6 !max-w-6',
  paymentMethod
}) => (
  <img
    src={PAYMENT_METHOD_ICONS_MAP[paymentMethod]}
    className={className}
    loading="lazy"
  />
)

export default PaymentMethodIcon
