import { useState } from 'react'
import PaymentMethodIcon from './PaymentMethodIcon'

const MAX_MOBILE = 3
const MAX_TABLET = 5
const MAX_DESKTOP = 7

const getMaxVisibleByWidth = () => {
  const width = window.innerWidth
  if (width >= 1024) return MAX_DESKTOP
  if (width >= 768) return MAX_TABLET
  return MAX_MOBILE
}

const PaymentMethodLabel = ({ paymentMethodTitle, paymentMethodIcons }) => {
  const [showHidden, setShowHidden] = useState(false)

  const maxVisible = getMaxVisibleByWidth()
  const visibleIcons = paymentMethodIcons.slice(0, maxVisible)
  const hiddenIcons = paymentMethodIcons.slice(maxVisible)

  return (
    <div className="mt-[1px] flex justify-between items-center w-full">
      <span>{paymentMethodTitle}</span>

      <span>
        <div className="relative inline-block">
          <div className="flex items-center space-x-3">
            {visibleIcons.map((icon) => (
              <PaymentMethodIcon paymentMethod={icon} />
            ))}

            {hiddenIcons.length > 0 && (
              <div
                className="text-sm text-gray-600 bg-gray-100 px-2 py-1 rounded relative"
                onMouseEnter={() => setShowHidden(true)}
                onMouseLeave={() => setShowHidden(false)}
              >
                +{hiddenIcons.length}
                {showHidden && (
                  <div
                    className={`w-auto absolute z-10 top-full mt-2 left-1/2 -translate-x-1/2 bg-white border border-gray-200 rounded shadow-md px-3 py-2 flex space-x-2 transition-opacity duration-150 ${
                      showHidden
                        ? 'opacity-100 visible'
                        : 'opacity-0 invisible pointer-events-none'
                    }`}
                  >
                    {hiddenIcons.map((icon) => (
                      <PaymentMethodIcon paymentMethod={icon} />
                    ))}
                  </div>
                )}
              </div>
            )}
          </div>
        </div>
      </span>
    </div>
  )
}

export default PaymentMethodLabel
