const PaymentMethodSkeleton = () => {
  let borderRadius = '.5rem'
  let baseColor = '#e2e8f0'

  return (
    <div className="flex flex-col w-full transition duration-300 ease-in data-[closed]:opacity-0">
      <div className="flex flex-col gap-4 pb-6 mb-8 border-b border-slate-200">
        <div className="w-2/6 h-4 space-y-6 animate-pulse rounded bg-slate-300" />
        <div
          className="border p-6"
          style={{
            borderColor: baseColor,
            borderRadius: borderRadius
          }}
        >
          <div className="flex gap-2.5 flex-col">
            <div className="flex items-center gap-2.5 flex-row">
              <div className="w-4 h-4 animate-pulse rounded bg-slate-300" />
              <div className="w-44 h-4 animate-pulse rounded bg-slate-300" />
            </div>
            <div className="flex gap-2.5 flex-col mt-4">
              <div className="flex flex-col gap-2">
                <div className="w-24 h-3 animate-pulse rounded bg-slate-300" />
                <div
                  className="border p-3"
                  style={{
                    borderColor: baseColor,
                    borderRadius: borderRadius
                  }}
                >
                  <div className="w-24 h-3 animate-pulse rounded bg-slate-300" />
                </div>
              </div>
              <div className="flex gap-2.5 flex-row">
                <div className="flex flex-col gap-2 basis-1/2">
                  <div className="w-12 h-3 animate-pulse rounded bg-slate-300" />
                  <div
                    className="border p-3"
                    style={{
                      borderColor: baseColor,
                      borderRadius: borderRadius
                    }}
                  >
                    <div className="w-12 h-3 animate-pulse rounded bg-slate-300" />
                  </div>
                </div>
                <div className="flex flex-col gap-2 basis-1/2">
                  <div className="w-8 h-3 animate-pulse rounded bg-slate-300" />
                  <div
                    className="border p-3"
                    style={{
                      borderColor: baseColor,
                      borderRadius: borderRadius
                    }}
                  >
                    <div className="w-8 h-3 animate-pulse rounded bg-slate-300" />
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
        <div
          className="border p-6"
          style={{
            borderColor: baseColor,
            borderRadius: borderRadius
          }}
        >
          <div className="flex gap-2.5 flex-col">
            <div className="flex items-center gap-2.5 flex-row">
              <div className="w-4 h-4 animate-pulse rounded bg-slate-300" />
              <div className="w-24 h-4 animate-pulse rounded bg-slate-300" />
            </div>
          </div>
        </div>
      </div>
      <div className="flex flex-col gap-4">
        <div className="w-2/6 h-4 space-y-6 animate-pulse rounded bg-slate-300" />
        <div className="flex flex-col gap-2">
          <div className="w-24 h-3 animate-pulse rounded bg-slate-300" />
          <div
            className="border p-3"
            style={{
              borderColor: baseColor,
              borderRadius: borderRadius
            }}
          >
            <div className="w-36 h-3 animate-pulse rounded bg-slate-300" />
          </div>
        </div>
        <div className="flex flex-col gap-2">
          <div className="w-24 h-3 animate-pulse rounded bg-slate-300" />
          <div
            className="border p-3"
            style={{
              borderColor: baseColor,
              borderRadius: borderRadius
            }}
          >
            <div className="w-52 h-3 animate-pulse rounded bg-slate-300" />
          </div>
        </div>
      </div>
    </div>
  )
}

export default PaymentMethodSkeleton
