/**
 * This is the js file used to register the PayRex payment method to WooCommerce Blocks.
 * Used if a user is not logged in to complete a payment
 */
import PaymentMethodLabel from './Components/PaymentMethodLabel'
import PaymentMethod from './Components/PaymentMethod'

const payrexData = window.wc.wcSettings.getSetting('payrex_data', {})
const payrexLabel = window.wp.htmlEntities.decodeEntities(payrexData.title)

const payrex = {
  name: 'payrex',
  label: (
    <PaymentMethodLabel
      paymentMethodTitle={payrexData.title}
      paymentMethodIcons={payrexData.payment_method_icons}
    />
  ),
  icon: payrexData.icon,
  content: <PaymentMethod />,
  edit: <PaymentMethod />,
  paymentMethodData: () => {
    return {}
  },
  canMakePayment: () => true,
  placeOrderButtonLabel: 'Continue',
  ariaLabel: payrexLabel
}

window.wc.wcBlocksRegistry.registerPaymentMethod(payrex)

function movePaymentNotices() {
  const paymentNoticeWrapper = '#payment-method .wc-block-components-notices'

  const moveNotice = function (paymentNoticeWrapperElement) {
    const notices = document.querySelector('.woocommerce-notices-wrapper')

    if (notices) {
      Array.from(notices.children).forEach((child) => {
        if (
          child.dataset.contexts &&
          child.dataset.contexts === 'wc/checkout/payments'
        ) {
          paymentNoticeWrapperElement.appendChild(child)
        }
      })
    }
  }

  const observer = new MutationObserver(() => {
    const paymentNoticeWrapperElement =
      document.querySelector(paymentNoticeWrapper)

    if (paymentNoticeWrapperElement) {
      moveNotice(paymentNoticeWrapperElement)
      observer.disconnect()
    }
  })

  observer.observe(document.body, {
    childList: true,
    subtree: true
  })
}

movePaymentNotices()
