import { useState, useCallback } from 'react'

export function usePaymentIntent() {
  const [loading, setLoading] = useState(false)
  const [error, setError] = useState(null)
  const [paymentIntent, setPaymentIntent] = useState(null)

  const fetchPaymentIntent = useCallback(async () => {
    setLoading(true)
    setError(null)

    try {
      const checkoutData = window?.wc?.wcSettings?.getSetting('checkoutData')

      const response = await fetch('/wp-json/wc-payrex/v1/payment-intents', {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'X-Wc-Payrex-Token': window.payrex_payment_method_data.token
        },
        body: JSON.stringify({
          order_id: checkoutData.order_id,
          order_key: checkoutData.order_key
        })
      })

      if (!response.ok) {
        throw new Error(`Request failed with status ${response.status}`)
      }

      const data = await response.json()

      setPaymentIntent(data)
      return data
    } catch (err) {
      setError(err)
    } finally {
      setLoading(false)
    }
  }, [])

  return {
    fetchPaymentIntent,
    paymentIntent,
    loading,
    error
  }
}
