import { useRef } from 'react'

const sessionStore = {}

export function usePayrexSession() {
  const storeRef = useRef(sessionStore)

  const setPayrexSession = (key, value) => {
    storeRef.current[key] = value
  }

  const getPayrexSession = (key) => {
    return storeRef.current[key]
  }

  const clear = () => {
    Object.keys(storeRef.current).forEach((key) => delete storeRef.current[key])
  }

  return {
    getPayrexSession,
    setPayrexSession,
    clear
  }
}
